/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.dom;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.autoplot.MouseModuleType;
import org.autoplot.dom.Diff;
import org.autoplot.dom.DomNode;
import org.autoplot.dom.OptionsPrefsController;
import org.autoplot.dom.PropertyChangeDiff;
import org.das2.graph.DasColorBar;

public final class Options
extends DomNode {
    public static final String PROP_COLOR = "color";
    public static final String PROP_FILLCOLOR = "fillColor";
    public static final String VALUE_AUTORANGE_TYPE_RELUCTANT = "reluctant";
    protected boolean scriptVisible = false;
    public static final String PROP_SCRIPTVISIBLE = "scriptVisible";
    protected boolean logConsoleVisible = false;
    public static final String PROP_LOGCONSOLEVISIBLE = "logConsoleVisible";
    public static final String PROP_DATAVISIBLE = "dataVisible";
    protected boolean dataVisible = true;
    public static final String PROP_LAYOUTVISIBLE = "layoutVisible";
    protected boolean layoutVisible = true;
    protected boolean serverEnabled = false;
    public static final String PROP_SERVERENABLED = "serverEnabled";
    protected String canvasFont = "sans-12";
    public static final String PROP_CANVASFONT = "canvasFont";
    protected int width = 640;
    public static final String PROP_WIDTH = "width";
    protected int height = 480;
    public static final String PROP_HEIGHT = "height";
    protected Color foreground = Color.black;
    public static final String PROP_FOREGROUND = "foreground";
    protected Color background = Color.white;
    public static final String PROP_BACKGROUND = "background";
    protected Color color = Color.BLACK;
    protected Color fillColor = Color.DARK_GRAY;
    public static final String PROP_COLORTABLE = "colortable";
    protected DasColorBar.Type colortable = DasColorBar.Type.COLOR_WEDGE;
    protected boolean oppositeAxisVisible = false;
    public static final String PROP_OPPOSITEAXISVISIBLE = "oppositeAxisVisible";
    protected String ticklen = "0.66em";
    public static final String PROP_TICKLEN = "ticklen";
    protected String lineThickness = "1px";
    public static final String PROP_LINE_THICKNESS = "lineThickness";
    protected float multiLineTextAlignment = 0.5f;
    public static final String PROP_MULTILINETEXTALIGNMENT = "multiLineTextAlignment";
    protected boolean flipColorbarLabel = false;
    public static final String PROP_FLIPCOLORBARLABEL = "flipColorbarLabel";
    protected boolean specialEffects = false;
    public static final String PROP_SPECIALEFFECTS = "specialEffects";
    protected boolean drawAntiAlias = true;
    public static final String PROP_DRAWANTIALIAS = "drawAntiAlias";
    protected boolean textAntiAlias = true;
    public static final String PROP_TEXTANTIALIAS = "textAntiAlias";
    protected boolean drawGrid = false;
    public static final String PROP_DRAWGRID = "drawGrid";
    protected boolean drawMinorGrid = false;
    public static final String PROP_DRAWMINORGRID = "drawMinorGrid";
    public static final String PROP_OVERRENDERING = "overRendering";
    protected boolean overRendering = false;
    protected boolean autoranging = true;
    public static final String PROP_AUTORANGING = "autoranging";
    private String autorangeType = "";
    public static final String PROP_AUTORANGETYPE = "autorangeType";
    protected boolean autolabelling = true;
    public static final String PROP_AUTOLABELLING = "autolabelling";
    protected boolean autolayout = true;
    public static final String PROP_AUTOLAYOUT = "autolayout";
    protected boolean dayOfYear = false;
    public static final String PROP_DAY_OF_YEAR = "dayOfYear";
    public static final String PROP_USE_TIME_RANGE_EDITOR = "useTimeRangeEditor";
    protected boolean useTimeRangeEditor = false;
    protected boolean nearestNeighbor = false;
    public static final String PROP_NEARESTNEIGHBOR = "nearestNeighbor";
    protected MouseModuleType mouseModule = MouseModuleType.boxZoom;
    public static final String PROP_MOUSEMODULE = "mouseModule";
    protected boolean sliceRebinnedData = false;
    public static final String PROP_SLICEREBINNEDDATA = "sliceRebinnedData";
    protected String printingTag = "";
    public static final String PROP_PRINTINGTAG = "printingTag";
    protected Level printingLogLevel = Level.ALL;
    public static final String PROP_PRINTINGLOGLEVEL = "printingLogLevel";
    protected Level displayLogLevel = Level.ALL;
    public static final String PROP_DISPLAYLOGLEVEL = "displayLogLevel";
    protected int logMessageTimeoutSec = 20;
    public static final String PROP_LOGMESSAGETIMEOUTSEC = "logMessageTimeoutSec";
    protected boolean scanEnabled = true;
    public static final String PROP_SCANENABLED = "scanEnabled";
    private OptionsPrefsController controller = null;

    public Options() {
        logger.fine("creating new Options node");
    }

    public boolean isScriptVisible() {
        return this.scriptVisible;
    }

    public void setScriptVisible(boolean scriptVisible) {
        boolean oldScriptVisible = this.scriptVisible;
        this.scriptVisible = scriptVisible;
        this.propertyChangeSupport.firePropertyChange(PROP_SCRIPTVISIBLE, oldScriptVisible, scriptVisible);
    }

    public boolean isLogConsoleVisible() {
        return this.logConsoleVisible;
    }

    public void setLogConsoleVisible(boolean logConsoleVisible) {
        boolean oldLogConsoleVisible = this.logConsoleVisible;
        this.logConsoleVisible = logConsoleVisible;
        this.propertyChangeSupport.firePropertyChange(PROP_LOGCONSOLEVISIBLE, oldLogConsoleVisible, logConsoleVisible);
    }

    public boolean isDataVisible() {
        return this.dataVisible;
    }

    public void setDataVisible(boolean dataVisible) {
        boolean oldDataVisible = this.dataVisible;
        this.dataVisible = dataVisible;
        this.propertyChangeSupport.firePropertyChange(PROP_DATAVISIBLE, oldDataVisible, dataVisible);
    }

    public boolean isLayoutVisible() {
        return this.layoutVisible;
    }

    public void setLayoutVisible(boolean layoutVisible) {
        boolean oldLayoutVisible = this.layoutVisible;
        this.layoutVisible = layoutVisible;
        this.propertyChangeSupport.firePropertyChange(PROP_LAYOUTVISIBLE, oldLayoutVisible, layoutVisible);
    }

    public boolean isServerEnabled() {
        return this.serverEnabled;
    }

    public void setServerEnabled(boolean serverEnabled) {
        boolean oldServerEnabled = this.serverEnabled;
        this.serverEnabled = serverEnabled;
        this.propertyChangeSupport.firePropertyChange(PROP_SERVERENABLED, oldServerEnabled, serverEnabled);
    }

    public String getCanvasFont() {
        return this.canvasFont;
    }

    public void setCanvasFont(String canvasFont) {
        String oldCanvasFont = this.canvasFont;
        this.canvasFont = canvasFont;
        this.propertyChangeSupport.firePropertyChange(PROP_CANVASFONT, oldCanvasFont, canvasFont);
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        int oldWidth = this.width;
        this.width = width;
        this.propertyChangeSupport.firePropertyChange(PROP_WIDTH, oldWidth, width);
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        int oldHeight = this.height;
        this.height = height;
        this.propertyChangeSupport.firePropertyChange(PROP_HEIGHT, oldHeight, height);
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color foreground) {
        Color oldForeground = this.foreground;
        this.foreground = new Color(foreground.getRGB());
        this.propertyChangeSupport.firePropertyChange(PROP_FOREGROUND, oldForeground, foreground);
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color background) {
        Color oldBackground = this.background;
        this.background = new Color(background.getRGB());
        this.propertyChangeSupport.firePropertyChange(PROP_BACKGROUND, oldBackground, background);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        Color oldColor = this.color;
        this.color = new Color(color.getRGB());
        this.propertyChangeSupport.firePropertyChange(PROP_COLOR, oldColor, color);
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        Color oldFillColor = this.fillColor;
        this.fillColor = new Color(fillColor.getRGB());
        this.propertyChangeSupport.firePropertyChange(PROP_FILLCOLOR, oldFillColor, fillColor);
    }

    public DasColorBar.Type getColortable() {
        return this.colortable;
    }

    public void setColortable(DasColorBar.Type colortable) {
        DasColorBar.Type oldVal = this.colortable;
        this.colortable = colortable;
        this.propertyChangeSupport.firePropertyChange(PROP_COLORTABLE, oldVal, this.colortable);
    }

    public boolean isOppositeAxisVisible() {
        return this.oppositeAxisVisible;
    }

    public void setOppositeAxisVisible(boolean oppositeAxisVisible) {
        boolean oldOppositeAxisVisible = this.oppositeAxisVisible;
        this.oppositeAxisVisible = oppositeAxisVisible;
        this.propertyChangeSupport.firePropertyChange(PROP_OPPOSITEAXISVISIBLE, oldOppositeAxisVisible, oppositeAxisVisible);
    }

    public String getTicklen() {
        return this.ticklen;
    }

    public void setTicklen(String ticklen) {
        String oldTicklen = this.ticklen;
        this.ticklen = ticklen;
        this.propertyChangeSupport.firePropertyChange(PROP_TICKLEN, oldTicklen, ticklen);
    }

    public String getLineThickness() {
        return this.lineThickness;
    }

    public void setLineThickness(String lineThickness) {
        String oldLineThickness = this.lineThickness;
        this.lineThickness = lineThickness;
        this.propertyChangeSupport.firePropertyChange(PROP_LINE_THICKNESS, oldLineThickness, lineThickness);
    }

    public float getMultiLineTextAlignment() {
        return this.multiLineTextAlignment;
    }

    public void setMultiLineTextAlignment(float multiLineTextAlignment) {
        float oldMultiLineTextAlignment = this.multiLineTextAlignment;
        this.multiLineTextAlignment = multiLineTextAlignment;
        this.propertyChangeSupport.firePropertyChange(PROP_MULTILINETEXTALIGNMENT, Float.valueOf(oldMultiLineTextAlignment), Float.valueOf(multiLineTextAlignment));
    }

    public boolean isFlipColorbarLabel() {
        return this.flipColorbarLabel;
    }

    public void setFlipColorbarLabel(boolean flipColorbarLabel) {
        boolean oldFlipColorbarLabel = this.flipColorbarLabel;
        this.flipColorbarLabel = flipColorbarLabel;
        this.propertyChangeSupport.firePropertyChange(PROP_FLIPCOLORBARLABEL, oldFlipColorbarLabel, flipColorbarLabel);
    }

    public boolean isSpecialEffects() {
        return this.specialEffects;
    }

    public void setSpecialEffects(boolean specialEffects) {
        boolean oldSpecialEffects = this.specialEffects;
        this.specialEffects = specialEffects;
        this.propertyChangeSupport.firePropertyChange(PROP_SPECIALEFFECTS, oldSpecialEffects, specialEffects);
    }

    public boolean isDrawAntiAlias() {
        return this.drawAntiAlias;
    }

    public void setDrawAntiAlias(boolean drawAntiAlias) {
        boolean oldDrawAntiAlias = this.drawAntiAlias;
        this.drawAntiAlias = drawAntiAlias;
        this.propertyChangeSupport.firePropertyChange(PROP_DRAWANTIALIAS, oldDrawAntiAlias, drawAntiAlias);
    }

    public boolean isTextAntiAlias() {
        return this.textAntiAlias;
    }

    public void setTextAntiAlias(boolean textAntiAlias) {
        boolean oldTextAntiAlias = this.textAntiAlias;
        this.textAntiAlias = textAntiAlias;
        this.propertyChangeSupport.firePropertyChange(PROP_TEXTANTIALIAS, oldTextAntiAlias, textAntiAlias);
    }

    public boolean isDrawGrid() {
        return this.drawGrid;
    }

    public void setDrawGrid(boolean drawGrid) {
        boolean oldDrawGrid = this.drawGrid;
        this.drawGrid = drawGrid;
        this.propertyChangeSupport.firePropertyChange(PROP_DRAWGRID, oldDrawGrid, drawGrid);
    }

    public boolean isDrawMinorGrid() {
        return this.drawMinorGrid;
    }

    public void setDrawMinorGrid(boolean drawMinorGrid) {
        boolean oldDrawMinorGrid = this.drawMinorGrid;
        this.drawMinorGrid = drawMinorGrid;
        this.propertyChangeSupport.firePropertyChange(PROP_DRAWMINORGRID, oldDrawMinorGrid, drawMinorGrid);
    }

    public boolean isOverRendering() {
        return this.overRendering;
    }

    public void setOverRendering(boolean overRendering) {
        boolean oldValue = this.overRendering;
        this.overRendering = overRendering;
        this.propertyChangeSupport.firePropertyChange(PROP_OVERRENDERING, oldValue, overRendering);
    }

    public boolean isAutoranging() {
        return this.autoranging;
    }

    public void setAutoranging(boolean newautoranging) {
        boolean oldautoranging = this.autoranging;
        this.autoranging = newautoranging;
        this.propertyChangeSupport.firePropertyChange(PROP_AUTORANGING, oldautoranging, newautoranging);
    }

    public String getAutorangeType() {
        return this.autorangeType;
    }

    public void setAutorangeType(String autorangeType) {
        String oldAutorangeType = this.autorangeType;
        this.autorangeType = autorangeType;
        this.propertyChangeSupport.firePropertyChange(PROP_AUTORANGETYPE, oldAutorangeType, autorangeType);
    }

    public boolean isAutolabelling() {
        return this.autolabelling;
    }

    public void setAutolabelling(boolean autolabelling) {
        boolean oldAutolabelling = this.autolabelling;
        this.autolabelling = autolabelling;
        this.propertyChangeSupport.firePropertyChange(PROP_AUTOLABELLING, oldAutolabelling, autolabelling);
    }

    public boolean isAutolayout() {
        return this.autolayout;
    }

    public void setAutolayout(boolean autolayout) {
        boolean oldAutolayout = this.autolayout;
        this.autolayout = autolayout;
        this.propertyChangeSupport.firePropertyChange(PROP_AUTOLAYOUT, oldAutolayout, autolayout);
    }

    public boolean isDayOfYear() {
        return this.dayOfYear;
    }

    public void setDayOfYear(boolean dayOfYear) {
        boolean old = this.dayOfYear;
        this.dayOfYear = dayOfYear;
        this.propertyChangeSupport.firePropertyChange(PROP_DAY_OF_YEAR, old, dayOfYear);
    }

    public boolean isUseTimeRangeEditor() {
        return this.useTimeRangeEditor;
    }

    public void setUseTimeRangeEditor(boolean useTimeRangeEditor) {
        boolean old = this.useTimeRangeEditor;
        this.useTimeRangeEditor = useTimeRangeEditor;
        this.propertyChangeSupport.firePropertyChange(PROP_USE_TIME_RANGE_EDITOR, old, useTimeRangeEditor);
    }

    public boolean isNearestNeighbor() {
        return this.nearestNeighbor;
    }

    public void setNearestNeighbor(boolean nearestNeighbor) {
        boolean old = this.nearestNeighbor;
        this.nearestNeighbor = nearestNeighbor;
        this.propertyChangeSupport.firePropertyChange(PROP_NEARESTNEIGHBOR, old, nearestNeighbor);
    }

    public MouseModuleType getMouseModule() {
        return this.mouseModule;
    }

    public void setMouseModule(MouseModuleType mouseModule) {
        MouseModuleType oldMouseModule = this.mouseModule;
        this.mouseModule = mouseModule;
        this.propertyChangeSupport.firePropertyChange(PROP_MOUSEMODULE, (Object)oldMouseModule, (Object)mouseModule);
    }

    public boolean isSliceRebinnedData() {
        return this.sliceRebinnedData;
    }

    public void setSliceRebinnedData(boolean sliceRebinnedData) {
        boolean oldSliceRebinnedData = this.sliceRebinnedData;
        this.sliceRebinnedData = sliceRebinnedData;
        this.propertyChangeSupport.firePropertyChange(PROP_SLICEREBINNEDDATA, oldSliceRebinnedData, sliceRebinnedData);
    }

    public String getPrintingTag() {
        return this.printingTag;
    }

    public void setPrintingTag(String printingTag) {
        String oldPrintingTag = this.printingTag;
        this.printingTag = printingTag;
        this.propertyChangeSupport.firePropertyChange(PROP_PRINTINGTAG, oldPrintingTag, printingTag);
    }

    public Level getPrintingLogLevel() {
        return this.printingLogLevel;
    }

    public void setPrintingLogLevel(Level printingLogLevel) {
        Level oldPrintingLogLevel = this.printingLogLevel;
        this.printingLogLevel = printingLogLevel;
        this.propertyChangeSupport.firePropertyChange(PROP_PRINTINGLOGLEVEL, oldPrintingLogLevel, printingLogLevel);
    }

    public Level getDisplayLogLevel() {
        return this.displayLogLevel;
    }

    public void setDisplayLogLevel(Level displayLogLevel) {
        Level oldDisplayLogLevel = this.displayLogLevel;
        this.displayLogLevel = displayLogLevel;
        this.propertyChangeSupport.firePropertyChange(PROP_DISPLAYLOGLEVEL, oldDisplayLogLevel, displayLogLevel);
    }

    public int getLogMessageTimeoutSec() {
        return this.logMessageTimeoutSec;
    }

    public void setLogMessageTimeoutSec(int logMessageTimeoutSec) {
        int oldLogMessageTimeoutSec = this.logMessageTimeoutSec;
        this.logMessageTimeoutSec = logMessageTimeoutSec;
        this.propertyChangeSupport.firePropertyChange(PROP_LOGMESSAGETIMEOUTSEC, oldLogMessageTimeoutSec, logMessageTimeoutSec);
    }

    public boolean isScanEnabled() {
        return this.scanEnabled;
    }

    public void setScanEnabled(boolean scanEnabled) {
        boolean oldScanEnabled = this.scanEnabled;
        this.scanEnabled = scanEnabled;
        this.propertyChangeSupport.firePropertyChange(PROP_SCANENABLED, oldScanEnabled, scanEnabled);
    }

    public void syncToAll(DomNode n, List<String> exclude) {
        this.syncTo(n, exclude);
        if (!(n instanceof Options)) {
            throw new IllegalArgumentException("node should be a Options");
        }
        Options that = (Options)n;
        if (!exclude.contains(PROP_MULTILINETEXTALIGNMENT)) {
            this.setMultiLineTextAlignment(that.getMultiLineTextAlignment());
        }
        if (!exclude.contains(PROP_OVERRENDERING)) {
            this.setOverRendering(that.isOverRendering());
        }
        if (!exclude.contains(PROP_TEXTANTIALIAS)) {
            this.setTextAntiAlias(that.isTextAntiAlias());
        }
        if (!exclude.contains(PROP_PRINTINGLOGLEVEL)) {
            this.setPrintingLogLevel(that.getPrintingLogLevel());
        }
        if (!exclude.contains(PROP_DISPLAYLOGLEVEL)) {
            this.setDisplayLogLevel(that.getDisplayLogLevel());
        }
        if (!exclude.contains(PROP_DAY_OF_YEAR)) {
            this.setDayOfYear(that.isDayOfYear());
        }
    }

    @Override
    public void syncTo(DomNode n, List<String> exclude) {
        super.syncTo(n, exclude);
        if (!(n instanceof Options)) {
            throw new IllegalArgumentException("node should be a Options");
        }
        Options that = (Options)n;
        if (!exclude.contains(PROP_BACKGROUND)) {
            this.setBackground(that.getBackground());
        }
        if (!exclude.contains(PROP_FOREGROUND)) {
            this.setForeground(that.getForeground());
        }
        if (!exclude.contains(PROP_COLOR)) {
            this.setColor(that.getColor());
        }
        if (!exclude.contains(PROP_FILLCOLOR)) {
            this.setFillColor(that.getFillColor());
        }
        if (!exclude.contains(PROP_COLORTABLE)) {
            this.setColortable(that.getColortable());
        }
        if (!exclude.contains(PROP_CANVASFONT)) {
            this.setCanvasFont(that.getCanvasFont());
        }
        if (!exclude.contains(PROP_USE_TIME_RANGE_EDITOR)) {
            this.setUseTimeRangeEditor(that.isUseTimeRangeEditor());
        }
        if (!exclude.contains(PROP_FLIPCOLORBARLABEL)) {
            this.setFlipColorbarLabel(that.isFlipColorbarLabel());
        }
        if (!exclude.contains(PROP_TICKLEN)) {
            this.setTicklen(that.getTicklen());
        }
        if (!exclude.contains(PROP_OPPOSITEAXISVISIBLE)) {
            this.setOppositeAxisVisible(that.isOppositeAxisVisible());
        }
        if (!exclude.contains(PROP_LINE_THICKNESS)) {
            this.setLineThickness(that.getLineThickness());
        }
        if (!exclude.contains(PROP_SCANENABLED)) {
            this.setScanEnabled(that.isScanEnabled());
        }
        if (!exclude.contains(PROP_DRAWGRID)) {
            this.setDrawGrid(that.isDrawGrid());
        }
        if (!exclude.contains(PROP_DRAWMINORGRID)) {
            this.setDrawMinorGrid(that.isDrawMinorGrid());
        }
    }

    @Override
    public void syncTo(DomNode n) {
        this.syncTo(n, new ArrayList<String>());
    }

    @Override
    public List<Diff> diffs(DomNode node) {
        if (!(node instanceof Options)) {
            throw new IllegalArgumentException("node should be a Options");
        }
        Options that = (Options)node;
        List<Diff> result = super.diffs(node);
        boolean b = that.getBackground().equals(this.getBackground());
        if (!b) {
            result.add(new PropertyChangeDiff(PROP_BACKGROUND, that.getBackground(), this.getBackground()));
        }
        if (!(b = that.getForeground().equals(this.getForeground()))) {
            result.add(new PropertyChangeDiff(PROP_FOREGROUND, that.getForeground(), this.getForeground()));
        }
        if (!(b = that.getColor().equals(this.getColor()))) {
            result.add(new PropertyChangeDiff(PROP_COLOR, that.getColor(), this.getColor()));
        }
        if (!(b = that.getFillColor().equals(this.getFillColor()))) {
            result.add(new PropertyChangeDiff(PROP_FILLCOLOR, that.getFillColor(), this.getFillColor()));
        }
        if (!(b = that.getColortable().equals(this.getColortable()))) {
            result.add(new PropertyChangeDiff(PROP_COLORTABLE, that.getColortable(), this.getColortable()));
        }
        if (!(b = that.getCanvasFont().equals(this.getCanvasFont()))) {
            result.add(new PropertyChangeDiff(PROP_CANVASFONT, that.getCanvasFont(), this.getCanvasFont()));
        }
        boolean bl = b = that.isUseTimeRangeEditor() == this.isUseTimeRangeEditor();
        if (!b) {
            result.add(new PropertyChangeDiff(PROP_USE_TIME_RANGE_EDITOR, that.isUseTimeRangeEditor(), this.isUseTimeRangeEditor()));
        }
        boolean bl2 = b = that.isFlipColorbarLabel() == this.isFlipColorbarLabel();
        if (!b) {
            result.add(new PropertyChangeDiff(PROP_FLIPCOLORBARLABEL, that.isFlipColorbarLabel(), this.isFlipColorbarLabel()));
        }
        if (!(b = that.getTicklen().equals(this.getTicklen()))) {
            result.add(new PropertyChangeDiff(PROP_TICKLEN, that.getTicklen(), this.getTicklen()));
        }
        if (!(b = that.getLineThickness().equals(this.getLineThickness()))) {
            result.add(new PropertyChangeDiff(PROP_OPPOSITEAXISVISIBLE, that.isOppositeAxisVisible(), this.isOppositeAxisVisible()));
        }
        if (!(b = that.getLineThickness().equals(this.getLineThickness()))) {
            result.add(new PropertyChangeDiff(PROP_LINE_THICKNESS, that.getLineThickness(), this.getLineThickness()));
        }
        boolean bl3 = b = that.isScanEnabled() == this.isScanEnabled();
        if (!b) {
            result.add(new PropertyChangeDiff(PROP_SCANENABLED, that.isScanEnabled(), this.isScanEnabled()));
        }
        boolean bl4 = b = that.isDrawGrid() == this.isDrawGrid();
        if (!b) {
            result.add(new PropertyChangeDiff(PROP_DRAWGRID, that.isDrawGrid(), this.isDrawGrid()));
        }
        boolean bl5 = b = that.isDrawMinorGrid() == this.isDrawMinorGrid();
        if (!b) {
            result.add(new PropertyChangeDiff(PROP_DRAWMINORGRID, that.isDrawMinorGrid(), this.isDrawMinorGrid()));
        }
        return result;
    }

    public OptionsPrefsController getController() {
        return this.controller;
    }

    protected void setController(OptionsPrefsController controller) {
        if (this.controller != null) {
            throw new IllegalArgumentException("controller has already been set");
        }
        this.controller = controller;
    }

    @Override
    public DomNode copy() {
        Options that = new Options();
        that.setBackground(this.getBackground());
        that.setForeground(this.getForeground());
        that.setColor(this.getColor());
        that.setFillColor(this.getFillColor());
        that.setColortable(this.getColortable());
        that.setCanvasFont(this.getCanvasFont());
        that.setUseTimeRangeEditor(this.isUseTimeRangeEditor());
        that.setFlipColorbarLabel(this.isFlipColorbarLabel());
        that.setTicklen(this.getTicklen());
        that.setOppositeAxisVisible(this.isOppositeAxisVisible());
        that.setLineThickness(this.getLineThickness());
        that.setScanEnabled(this.isScanEnabled());
        that.setDrawGrid(this.isDrawGrid());
        that.setDrawMinorGrid(this.isDrawMinorGrid());
        return that;
    }
}

